% Count up the syllables, etc. 
% The results structure has two parts:
%   * The syllable / transition indices into the global list
%   * The occurrences:
%       - [babble utterance line number place_in_utterance syllables_in_utterances]
function results = tabulateBabble(babble, b_num, results)

% First, grab the baseline syllables for that day
results.total_syl(b_num) = 0;
for b = 1:length(babble)
    results.total_syl(b_num) = results.total_syl(b_num) + length(getSyllablesFromParse(babble{b}));
end

% Go through each babble utterance
for b = 1:length(babble)

    % Only analyze if parsed correctly
    syllables = getSyllablesFromParse(babble{b});
    if ~isempty(syllables)

        % Add the syllables and the transitions
        for s = 1:length(syllables)
            
            % Might not have it yet
            if length(results.syllables) < syllables(s) ||...
                    isempty(results.syllables{syllables(s)})
                results.syllables{syllables(s)} = {[b_num b babble{b}{1} s length(syllables)]};

            % Or add
            else
                results.syllables{syllables(s)}{end+1} = [b_num b babble{b}{1} s length(syllables)];
            end

            % And the transition, if there is one
            if s > 1

                % Might not have it yet
                if size(results.transitions,1) < syllables(s-1) || size(results.transitions,2) < syllables(s) ||...
                        isempty(results.transitions{syllables(s-1),syllables(s)})
                    results.transitions{syllables(s-1), syllables(s)} = {[b_num b babble{b}{1} s-1 (length(syllables)-1)]};

                % Or add
                else
                    results.transitions{syllables(s-1), syllables(s)}{end+1} = [b_num b babble{b}{1} s-1 (length(syllables)-1)];
                end
            end
        end
    end
end

