%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% File: loadGlobalInfo.m
%
% Load the global syllables, etc. Call this to
%   load all_syllables, all_consonants, and
%   all_vowels into global memory. These are
%   mappings from sets of bytes to the respective
%   indices.
%
% To fix a parse:
%
% To get the unfinished parses, type
%   >> babbles{num_babble}{4}{:}
% To get the unparsed phonemes type
%   >> babbles{num_babble}{4}{num_parse}{2}
% To get the phonemes type
%   >> babbles{num_babble}{3}
% To get the line of the babble in the file type
%   >> babbles{num_babble}{1}
%
% Check the .cha line to see the IPA symbols.
% These are good references: 
%   * http://ipa.typeit.org/full/
%   * http://en.wikipedia.org/wiki/International_Phonetic_Alphabet
%   * http://en.wikipedia.org/wiki/Wikipedia:IPA_for_English
%   * http://cla.calpoly.edu/~jrubba/phon/syllables.html
%   * http://web.uvic.ca/ling/resources/ipa/charts/IPAlab/IPAlab.htm
%   * http://www.phon.ucl.ac.uk/home/wells/ipa-english-uni.htm
%   * http://www.oed.com/public/keytopronunciation
%   * http://cals.conlang.org/sound/
%
% If you add a syllable to loadSyllables.m, make
%   sure to clear the global all_syllables and
%   then reparse.
%
% If in doubt, make sure each syllable only has one 
%   vowel...
%
function loadGlobalInfo

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% WARNING: If you change the order of existing syllables,
%   you will have to reparse everything.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Assign all the syllables we know about
% NOTE: Removed all single consonants as syllables:
global all_syllables;
all_syllables = {...
      {109}...                    %  1: 'm'   - This appears as a syllable itself e.g. Ben10.cha line 8.   
      {[109, 203  144]}...         %##: XX - e.g. ben10.cha line 44, phonemes 1. NOTE: There are no vowels though...
      {109, [202  148], 109}...         %##: XX - e.g. ben10.cha line 48, phonemes 1-3. NOTE: There are no vowels though...
      {104, 109}...         %##: XX - e.g. ben10.cha line 150, phonemes 1, 2. NOTE: There are no vowels
      {110}...         %##: XX - e.g. ben10.cha line 154, phoneme 1. NOTE: There are no vowels
      {[104 203 144], [109 203 144]}...         %##: XX - e.g. ben02.cha line 8, phonemes 3, 4.
      {104, [109  203  144]}...         %##: XX - e.g. ben04.cha line 88, phonemes 1, 2.
    {[202 138]}...              %  2: '?'   - This vowel appears as a syllable itself e.g. Ben10.cha line 12.
    {98, [202 140]}...          %  3: 'b?'  - e.g. Ben10.cha line 12.
    {[201 170]}...              %  4: '?'   - This vowel appears as a syllable itself e.g. Ben10.cha line 14.
    {119, [201 170]}...         %  5: 'w?'  - e.g. Ben10.cha line 14.
    {98, 105}...                %  6: 'bi'  - e.g. Ben10.cha line 14.
    {100, 117}...               %  7: 'du'  - e.g. Ben10.cha line 16.
    {115, 111}...               %  8: 'so'  - e.g. Ben10.cha line 18.
    {119, 117}...               %  9: 'wu'  - e.g. Ben10.cha line 18.
    {100, [201 170]}...         % 10: 'd?'  - e.g. Ben10.cha line 20.
    {119, [201 153]}...         % 11: 'w?'  - e.g. Ben10.cha line 20.
    {98, 117}...                % 12: 'bu'  - e.g. Ben10.cha line 20.
    {98, [117 203 144]}...      % 13: 'bu?' - e.g. Ben10.cha line 22.
    {[202 140 201 170]}...      % 14: '??'  - This vowel appears as a syllable itself e.g. Ben10.cha line 26.
    {119, [202 138]}...         % 15: 'w?' - e.g. Ben10.cha line 34.
    {103, [202 138]}...         % 16: 'g?' - e.g. Ben10.cha line 36.
    {[202  140]}...         %##: XX - e.g. ben10.cha line 52.
    {105}...         %##: XX - e.g. ben10.cha line 128.
    {97}...         %##: XX - e.g. ben10.cha line 262.
    {[202  140  203  144]}...         %##: XX - e.g. ben10.cha line 232, phoneme 3.
    {109, 117}...         %##: XX - e.g. ben10.cha line 308, phonemes 1-2.
    {98, 101}...         %##: XX - e.g. ben10.cha line 112, phonemes 1, 2.
    {100, [202  140]}...         %##: XX - e.g. ben10.cha line 32, phonemes 1, 2.
    {100, 105}...         %##: XX - e.g. ben10.cha line 204, phonemes 1, 2.
    {104, [202  140]}...         %##: XX - e.g. ben10.cha line 62, phonemes 6, 7.
    {104, 105}...         %##: XX - e.g. ben10.cha line 238, phonemes 3, 4.
    {103, [202  140]}...         %##: XX - e.g. ben10.cha line 40, phonemes 1, 2.
    {103, 111}...         %##: XX - e.g. ben10.cha line 40, phonemes 3, 4.
    {100, 97}...         %##: XX - e.g. ben10.cha line 256, phonemes 1, 2.
    {119, 105}...         %##: XX - e.g. ben10.cha line 26, phonemes 3, 4.
    {109, 101}...         %##: XX - e.g. ben10.cha line 136, phonemes 6, 7.
    {98, [201  170]}...         %##: XX - e.g. ben10.cha line 112, phonemes 3, 4.
    {107, 117}...         %##: XX - e.g. ben10.cha line 78, phonemes 3, 4.
    {[202  146], 117}...         %##: XX - e.g. ben10.cha line 322, phonemes 4, 5.
    {[202  146], [201  170]}...         %##: XX - e.g. ben10.cha line 322, phonemes 2, 3.
    {119, 101}...         %##: XX - e.g. ben10.cha line 258, phonemes 3, 4.
    {98, 111}...         %##: XX - e.g. ben10.cha line 162, phonemes 1, 2.
    {[202  164], 111}...         %##: XX - e.g. ben10.cha line 162, phonemes 5, 6.
    {[202  164], [201  170]}...         %##: XX - e.g. ben10.cha line 32, phonemes 3, 4.
    {[202  164], [202  140]}...         %##: XX - e.g. ben10.cha line 112, phonemes 5, 6.
    {107, [202  140]}...         %##: XX - e.g. ben10.cha line 100, phonemes 1, 2.
    {98, 86}...         %##: XX - e.g. ben10.cha line 54, phonemes 3, 4.
    {100, 111}...         %##: XX - e.g. ben10.cha line 58, phonemes 1, 2.
    {[202  131], [201  154]}...         %##: XX - e.g. ben10.cha line 100, phonemes 3, 4.
    {[202  164], [117  203  144]}...         %##: XX - e.g. ben10.cha line 114, phonemes 3, 4.
    {104, [201  170]}...         %##: XX - e.g. ben10.cha line 62, phonemes 2, 3.
    {119, [101  203  144]}...         %##: XX - e.g. ben10.cha line 58, phonemes 3, 4.
    {107, 97}...         %##: XX - e.g. ben10.cha line 130, phonemes 1, 2.
    {117, 98}...         %##: XX - e.g. ben10.cha line 92, phonemes 1, 2.
    {[202  148], 97}...         %##: XX - e.g. ben10.cha line 316, phonemes 1, 2.
    {116, 117}...         %##: XX - e.g. ben10.cha line 266, phonemes 1, 2.
    {116, [202  140]}...         %##: XX - e.g. ben10.cha line 70, phonemes 1, 2.
    {119, [202  140]}...         %##: XX - e.g. ben10.cha line 264, phonemes 1, 2.
    {116, 97}...         %##: XX - e.g. ben10.cha line 86, phonemes 1, 2.
    {100, [201  154]}...         %##: XX - e.g. ben10.cha line 104, phonemes 1, 2.
    {119, [195  166]}...         %##: XX - e.g. ben10.cha line 264, phonemes 3, 4.
    {100, [111  203  144]}...         %##: XX - e.g. ben10.cha line 118, phonemes 1, 2.
    {119, 97}...         %##: XX - e.g. ben10.cha line 78, phonemes 1, 2.
    {107, [117  203  144]}...         %##: XX - e.g. ben10.cha line 148, phonemes 1, 2.
    {100, [117  203  144]}...         %##: XX - e.g. ben10.cha line 72, phonemes 1, 2.
    {[201  170], 103}...         %##: XX - e.g. ben10.cha line 96, phonemes 1, 2.
    {98, [201  154]}...         %##: XX - e.g. ben10.cha line 104, phonemes 5, 6.
    {103, [201  155]}...         %##: XX - e.g. ben10.cha line 96, phonemes 3, 4.
    {106, [202  140]}...         %##: XX - e.g. ben10.cha line 216, phonemes 8, 9.
    {104, 101}...         %##: XX - e.g. ben10.cha line 198, phonemes 2, 3.
    {106, 105}...         %##: XX - e.g. ben10.cha line 218, phonemes 2, 3.
    {106, 117}...         %##: XX - e.g. ben10.cha line 200, phonemes 3, 4.
    {[202  167], [202  140]}...         %##: XX - e.g. ben10.cha line 180, phonemes 2, 3.
    {100, 101}...         %##: XX - e.g. ben10.cha line 246, phonemes 6, 7.
    {[202  131], 117}...         %##: XX - e.g. ben10.cha line 200, phonemes 7, 8.
    {106, [201  155]}...         %##: XX - e.g. ben10.cha line 218, phonemes 4, 5.
    {119, [202 140], 98}...      % This is from ben10.cha line 294. Seems best...
    {104, [105  203  144]}...         %##: XX - e.g. ben10.cha line 272, phonemes 1, 2.
    {[105  203  144]}...         %##: XX - e.g. ben10.cha line 252, phonemes 1.
    {[111  203  144]}...         %##: XX - e.g. ben10.cha line 242, phonemes 3.
    {111}...         %##: XX - e.g. ben10.cha line 228, phonemes 6.
    {[97  203  144]}...         %##: XX - e.g. ben10.cha line 190, phonemes 1.
    {[201  170  203  144]}...         %##: XX - e.g. ben10.cha line 196, phonemes 3.
    {106, [201 155], 112}...    % From ben10.cha, phonemes 2-4.
    {98, [195  166]}...         %##: XX - e.g. ben10.cha line 214, phonemes 5, 6.
    {[195  166]}...         %##: XX - e.g. ben10.cha line 38, phoneme 1.
    {103, [195  166]}...         %##: XX - e.g. ben10.cha line 60, phonemes 4, 5.
    {98, [202  138],[202 146]}...         %##: XX - e.g. ben10.cha line 50, phonemes 3-5.
    {101}...                        %##: XX - e.g. ben10.cha line 56, phoneme 1.
    {[202  140], 108}...         %##: XX - e.g. ben10.cha line 56, phonemes 4, 5.
    {103, 117}...         %##: XX - e.g. ben10.cha line 68, phonemes 3, 4.
    {100, [201 155]}...         %##: XX - e.g. ben10.cha line 74, phonemes 1, 2.
    {117}...         %##: XX - e.g. ben10.cha line 74, phonemes 5.
    {[202  164], 105}...         %##: XX - e.g. ben10.cha line 206, phonemes 6, 7.
    {[202  164], [201 155], 98}...         %##: XX - e.g. ben10.cha line 98, phonemes 1-3.
    {98, [202  140], 98}...         %##: XX - e.g. ben10.cha line 98, phonemes 4-6.
    {[98  204  165], 117}...         %##: XX - e.g. ben10.cha line 154, phonemes 2, 3.
    {104, 117}...         %##: XX - e.g. ben10.cha line 156, phonemes 1, 2.
    {98, [111 203 144]}...         %##: XX - e.g. ben10.cha line 164, phonemes 3, 4.
    {[202 140], 116}...         %##: XX - e.g. ben10.cha line 172, phonemes 1, 2.
    {104, 111}...         %##: XX - e.g. ben10.cha line 172, phonemes 3, 4.
    {[201 154]}...         %##: XX - e.g. ben10.cha line 174, phoneme 1.
    {[97  201  170]}...         %##: XX - e.g. ben10.cha line 94, phonemes 3.
    {98, [97  201  170]}...         %##: XX - e.g. ben10.cha line 146, phonemes 3, 4.
    {119, [97  201  170]}...         %##: XX - e.g. ben10.cha line 202, phonemes 3, 4.
    {103, [97  201  170]}...         %##: XX - e.g. ben10.cha line 176, phonemes 1, 2.
    {106, [201  170]}...         %##: XX - e.g. ben10.cha line 226, phonemes 7, 8.
    {104, [202  138]}...         %##: XX - e.g. ben08.cha line 198, phonemes 3, 4.
    {98, [202  138]}...         %##: XX - e.g. ben08.cha line 114, phonemes 1, 2.
    {116, [202  138]}...         %##: XX - e.g. ben08.cha line 92, phonemes 3, 4.
    {100, [195  166]}...         %##: XX - e.g. ben08.cha line 16, phonemes 1, 2.
    {[202  164], [202  138]}...         %##: XX - e.g. ben08.cha line 92, phonemes 7, 8.
    {[201  155]}...         %##: XX - e.g. ben08.cha line 14, phonemes 1.
    {100, [202  138]}...         %##: XX - e.g. ben08.cha line 20, phonemes 1, 2.
    {[202  164], 101}...         %##: XX - e.g. ben08.cha line 116, phonemes 6, 7.
    {116, 101}...         %##: XX - e.g. ben08.cha line 46, phonemes 3, 4.
    {119, [202  140  203  144]}...         %##: XX - e.g. ben08.cha line 34, phonemes 1, 2.
    {119, 111}...         %##: XX - e.g. ben08.cha line 46, phonemes 5, 6.
    {[202  138  203  144]}...         %##: XX - e.g. ben08.cha line 338, phonemes 1.
    {[195  166  203  144]}...         %##: XX - e.g. ben08.cha line 328, phonemes 3.
    {109, 86}...         %##: XX - e.g. ben08.cha line 242, phonemes 8, 9.
    {104, [201  155]}...         %##: XX - e.g. ben08.cha line 88, phonemes 1, 2.
    {115, [195  166]}...         %##: XX - e.g. ben08.cha line 262, phonemes 3, 4.
    {104, [195  166]}...         %##: XX - e.g. ben08.cha line 172, phonemes 3, 4.
    {106, 97}...         %##: XX - e.g. ben08.cha line 44, phonemes 3, 4.
    {67, 111}...         %##: XX - e.g. ben08.cha line 60, phonemes 5, 6.
    {118, 97}...         %##: XX - e.g. ben08.cha line 134, phonemes 3, 4.
    {106, 101}...         %##: XX - e.g. ben08.cha line 122, phonemes 3, 4.
    {107, 111}...         %##: XX - e.g. ben08.cha line 108, phonemes 4, 5.
    {103, 105}...         %##: XX - e.g. ben08.cha line 300, phonemes 2, 3.
    {100, [97  201  170]}...         %##: XX - e.g. ben08.cha line 278, phonemes 1, 2.
    {106, [202  138]}...         %##: XX - e.g. ben08.cha line 264, phonemes 4, 5.
    {104, [202  138  203  144]}...         %##: XX - e.g. ben08.cha line 254, phonemes 1, 2.
    {104, [202  140  203  144]}...         %##: XX - e.g. ben08.cha line 198, phonemes 1, 2.
    {109, [202  140]}...         %##: XX - e.g. ben08.cha line 194, phonemes 5, 6.
    {[202  131], [202  138]}...         %##: XX - e.g. ben08.cha line 194, phonemes 3, 4.
    {[202  131], 111}...         %##: XX - e.g. ben08.cha line 194, phonemes 1, 2.
    {[201  170], 107}...         %##: XX - e.g. ben08.cha line 46, phonemes 1, 2.
    {108, [195  166]}...         %##: XX - e.g. ben08.cha line 150, phonemes 1, 2.
    {[100  202  176], 111}...         %##: XX - e.g. ben08.cha line 132, phonemes 1, 2.
    {103, 97}...         %##: XX - e.g. ben08.cha line 60, phonemes 1, 2.
    {67, 86}...         %##: XX - e.g. ben08.cha line 68, phonemes 1, 2.
    {104, [195  166  203  144]}...         %##: XX - e.g. ben08.cha line 96, phonemes 1, 2.
    {[202  148], [202  140]}...         %##: XX - e.g. ben08.cha line 110, phonemes 2, 3.
    {104, [101  203  144]}...         %##: XX - e.g. ben08.cha line 84, phonemes 4, 5.
    {[202  140], [116  202  176]}...         %##: XX - e.g. ben08.cha line 298, phonemes 1, 2.
    {102, 117}...         %##: XX - e.g. ben03.cha line 50, phonemes 2, 3.
    {[117  203  144]}...         %##: XX - e.g. ben03.cha line 60, phonemes 3.
    {100, 111, [202  148]}...         %##: XX - e.g. ben03.cha line 125, phonemes 2, 3, 4.
    {98, 97}...         %##: XX - e.g. ben03.cha line 88, phonemes 2, 3.
    {118, [202  140]}...         %##: XX - e.g. ben03.cha line 88, phonemes 6, 7.
    {[201  155  203  144]}...         %##: XX - e.g. ben03.cha line 98, phonemes 1.
    {117, [202  148]}...         %##: XX - e.g. ben03.cha line 141, phonemes 4, 5.
    {[202  140], 100}...         %##: XX - e.g. ben02.cha line 68, phonemes 1, 2.
    {[202  140], 104}...         %##: XX - e.g. ben02.cha line 68, phonemes 3, 4.
    {[202  140], [202  148]}...         %##: XX - e.g. ben02.cha line 96, phonemes 1, 2.
    {104, 97}...         %##: XX - e.g. ben02.cha line 146, phonemes 1, 2.
    {106, [195  166  203  144]}...         %##: XX - e.g. ben04.cha line 52, phonemes 1, 2.
    {[202 140], [101  203  144]}...         %##: XX - e.g. ben04.cha line 116, phonemes 1, 2.
    {118, 117}...         %##: XX - e.g. ben04.cha line 188, phonemes 1, 2.
    {[202  140], 118}...         %##: XX - e.g. ben04.cha line 190, phonemes 1, 2.
    {104, [201  170], 106}...         %##: XX - e.g. ben04.cha line 42, phonemes 1, 2, 3.
    {107, [201  155]}...         %##: XX - e.g. ben04.cha line 112, phonemes 2, 3.
    {100, 97, 98}...         %##: XX - e.g. ben04.cha line 146, phonemes 5, 6, 7.
    {[201  155], 104}...         %##: XX - e.g. ben06.cha line 366, phonemes 1, 2.
    {119, [202  138  203  144]}...         %##: XX - e.g. ben06.cha line 84, phonemes 1, 2.
    {[202  148], [202  138]}...         %##: XX - e.g. ben06.cha line};
    {86}...         %##: XX - e.g. ben06.cha line 22, phonemes 1.
    {104, [97  203  144]}...         %##: XX - e.g. Cam02.cha line 148, phonemes 1, 2.
    {110, [201  153]}...         %##: XX - e.g. Cam02.cha line 98, phonemes 1, 2.
    {110, [202  140]}...         %##: XX - e.g. Cam02.cha line 66, phonemes 2, 3.
    {100, [97  203  144]}...         %##: XX - e.g. Cam02.cha line 12, phonemes 1, 2.
    {110, [201  153], 110}...         %##: XX - e.g. Cam02.cha line 138, phonemes 7, 8, 9.
    {110, [202  140], 110}...         %##: XX - e.g. Cam02.cha line 106, phonemes 7, 8, 9.
    {[201  153]}...         %##: XX - e.g. Cam02.cha line 22, phonemes 3.
    {100, [195  166  203  144]}...         %##: XX - e.g. Cam02.cha line 68, phonemes 2, 3.
    {110, [201  155]}...         %##: XX - e.g. Cam02.cha line 132, phonemes 1, 2.
    {100, [97  203  144], 116}...         %##: XX - e.g. Cam02.cha line 14, phonemes 1, 2, 3.
    {[202  148], [97  203  144]}...         %##: XX - e.g. Cam02.cha line 146, phonemes 2, 3.
};

% For consonants and syllalbes: http://en.wikipedia.org/wiki/Phonetic_symbols_in_Unicode
%   * To get the hex unicode, try: getHexFromPhoneme
%
% Also: http://www.fileformat.info/info/unicode/char/2a4/index.htm
%   has phonemes not on the wiki page

% All the consonants
% NOTE: Took out 16, 99, 114, 113, 120, [107 202 176], [107 204 154], 
%   [201 185], [98 203 140], [201 184], because did not appear in any syllables
global all_consonants;
all_consonants = {...
    100, 119, 112, 98, 109, ...
    110, 102, 118, 115, 108, ...
    107, 104, 103, [109 203 144], ...
    [202 146], 116, 106, 67, ...
    [202 164], [202 148], [202  131],...
    [98  204  165], [202  167], [100  202  176],...
    [116 202 176], [104 203 144], ...
    [110  203  144], [119  203  144]...
};


% All the vowels
% NOTE: Took out 121, [201 155 204 131], because did not appear in any syllables
global all_vowels;
all_vowels = {...
    117,...                    % 'u' - close back rounded vowel
    101, [202 140], 105, ...
    111, 97, [201 170], [195 166],...
    [117 203 144], [202 138], ...
    86,...                      % 'V' - can't find it, but I assume it's a vowel from ben10.cha line 54
    [101 203 144], [201 155],...
    [201 154], [202 140 203 144], ...
    [111 203 144], [97 203 144],...
    [201 170 203 144], [105 203 144],...
    [97 201 170], [202 138 203 144],...
    [195 166 203 144], [201 155 203 144], ...
    [201 153], [202 140 201 170],...
    [201  170  204  131]...
};



