%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% File: getSyllableFromIndex.m
%
% Gets a syllable from and index eith in
%   bytes or phonemes (from the global
%   maps).
%
% Inputs:
%   * index: The index of the syllable.
%   * type: The type of return.
%       - 1: phonemes. (Default)
%       - 2: bytes.
%
% Outputs: 
%   syllable: The syllable. 
%
% Usage: syllable = getSyllableFromIndex(43)
%
% Author: Doug Bemis
% Date: 11/27/11
%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function syllable = getSyllableFromIndex(index, type)

% Default to printing
if ~exist('type','var')
    type = 1;
end

% Get the syllables
global all_syllables;
if isempty(all_syllables)
    loadSyllables;
end

% See if we have it first
syllable = {};
if index > 0 && index <= length(all_syllables)
    syllable_bytes = all_syllables{index};
else
    return;
end

% Might only want the bytes
if type == 2
    syllable = syllable_bytes;
    return;
end

% Now, convert to phonemes
global all_consonants;
global all_vowels;
lists = {{all_consonants,'c'},{all_vowels,'v'}};
for b = 1:length(syllable_bytes)
    
    % See if it's a consonant or a vowel
    found = 0;
    for l = 1:length(lists)
        
        % Might be done
        if found
            continue;
        end
        
        % Otherwise, check the list
        curr_list = lists{l}{1};
        for p = 1:length(curr_list)
            found = 1;
            
            % Has to be the same length and each syllable the same
            if length(syllable_bytes{b}) == length(curr_list{p})
                for i = 1:length(curr_list{p})
                    if curr_list{p}(i) ~= syllable_bytes{b}(i)
                        found = 0;
                    end
                end
            else
                found = 0;
            end
            
            % Add if found
            if found
                syllable{end+1} = [lists{l}{2} num2str(p)]; %#ok<AGROW>
                break;
            end
        end
    end    
    
    % Or bad
    if ~found
        error(['Phoneme ' num2str(b) ' not found in syllable ' num2str(index) '. Exiting...']);
    end    
end

