%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% File: getIndexFromSyllable.m
%
% Simply looks up a syllable in the global
%   map and returns its index.
%
% Inputs:
%   * syllable: The syllable to look up.
%
% Outputs: 
%   * index: It's index. ([] if not found).
%
% Usage: index = getIndexFromSyllable({97})
%
% Author: Doug Bemis
% Date: 11/27/11
%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function index = getIndexFromSyllable(syllable)

% Get the syllables
global all_syllables;
if isempty(all_syllables)
    loadGlobalInfo;
end

% And check
index = [];
for s = 1:length(all_syllables)
    
    % Set the syllable to check
    curr_syllable = all_syllables{s};
    
    % Check each phoneme
    found = 1;
    if length(syllable) ~= length(curr_syllable)
        found = 0;
    else
        for p = 1:length(curr_syllable)

            % Check each byte of the phoneme
            if length(syllable{p}) ~= length(curr_syllable{p})
                found = 0;
            else
                curr_phoneme = curr_syllable{p};
                test_phoneme = syllable{p};
                for i = 1:length(curr_phoneme)
                    if test_phoneme(i) ~= curr_phoneme(i)
                        found = 0;
                    end
                end
            end
        end
    end
    
    % If we found it, we're done
    if found
        index = s;
        break;
    end
end
