%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% File: assessBabbles.m
%
% Simple helper to determine which
%   babbles were parsed correctly.
%
% Inputs:
%   * babbles: The babbles to check
%   * show_output: 0 to suppress output
%       to command line. (Defaults to 1).
%
% Outputs: 
%   * good_parses: The full parses in the babbles.
%
% Usage: good_parses = assessBabbles(babbles)
%
% Author: Doug Bemis
% Date: 11/27/11
%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function good_parses = assessBabbles(babbles,show_output)

% Default to print
if nargin < 2
    show_output = 1;
end

% Go through each one and check
good_parses = 0;
for b = 1:length(babbles)
    
    % See if there are unparsed phonemes
    %   in the babble
    if ~isempty(babbles{b}{4}{1}{2})
        
        % Find the best parse
        syll_parsed = 0;
        for p = 1:length(babbles{b}{4})
            if length(babbles{b}{4}{p}{1}) > syll_parsed
                syll_parsed = length(babbles{b}{4}{p}{1});
            end
        end
        
        if show_output
            disp(['Unparsed babble (' num2str(b) ') at line: ' num2str(babbles{b}{1}) '. ' num2str(syll_parsed) ' syllables parsed.']);
        end
    else
        good_parses = good_parses+1;
    end
end
if show_output
    disp([num2str(good_parses) ' out of ' num2str(length(babbles)) ' babbles parsed.']);
end
