
%% This is the entry into the analysis

% NOTE: The best way to begin an analysis is to
%   call analyzeChild. The first time, it will
%   parse the .cha files using parseChat which
%   turns the chats into syllables. This is 
%   what fills out the 'babbles' return variable
%   The results struct is constructed in two
%   steps. The first calls tabulateBabble which
%   just catalogues the placements of each 
%   syllable within the chats. This is also
%   only done once, if results has no value
%   when called. The work of analyzeChild is
%   in getting the frequency counts for placements
%   etc. This result can then be saved by 
%   providing a save file name.

% This call makes sure we have the latest global info
clearGlobalInfo;

% This eventually gets used in getPhonemesFromBytes
global ignore_phoneme_modifiers;
ignore_phoneme_modifiers = 0;

% Create the analysis for the children
children = {'Cameron','Charlotte','Georgia','Paxton','Rachel','Rebecca','Rowan','Sam','Ben'};
for c = 1:length(children)
    [results babbles files] = analyzeChild('English-Davis_CHAT',children{c},[children{c} '_analysis_results.mat']);
end

%% Create the plots

% For the figures, use all children
children = {'Cameron','Charlotte','Georgia','Paxton','Rachel','Rebecca','Rowan','Sam','Ben'};

% Don't change these
min_child_sessions = 16;
syl_baseline = 0.01;
tr_baseline = 0;
ignore_prior_syllables = 1;
min_syl_freq = 1;
min_sess_syl = 1;
c_disp_type = 0;
min_age = 365;
min_parsed = 0;
num_boots = 20;

% Change this value for different types of plots
display_type = 2;   % 2 - For the normal values; 4 - W/ chance lines; 5 - Normalized

% Set to 1 to restrict to only the known transitions
use_known_transitions = 0;

% Create the figures
figure_settings = {{'SylEdgeFreq','Edge_Freq'},{'CumSylTransTypesDiff','Prop_Added_Norm_per_syl'},...
    {'SylDoubleFreq','Syl_Double_Freq'},{'SylDoubleFreq','Dev_Double_Freq'}};
for f = 1:length(figure_settings)
    measure_type = figure_settings{f}{1};
    plot_type = figure_settings{f}{2};
    
    % Change for development alignment
    if strcmp(plot_type,'Dev_Double_Freq')
        alignment = 3;
        min_babbling = 0.5;
    else
        alignment = 1;
        min_babbling = 0;
    end
    [means stderrs all_values unused ] = plotMultipleTrends(children, '.', measure_type,alignment, min_child_sessions, syl_baseline,tr_baseline,...
        ignore_prior_syllables,min_syl_freq, min_sess_syl, min_babbling, min_parsed, min_age, num_boots,[plot_type '.jpg'], [plot_type '.txt'], display_type,[plot_type '.jpg'],'',c_disp_type,0,'',use_known_transitions);
end
